

function handleSlidePanel() {
    if ("undefined" != typeof $.slidePanel) {
        var defaults = $.components.getDefaults("slidePanel"),
            options = $.extend({}, defaults, {
            template: function (options) {
                return '<div class="' + options.classes.base + " " + options.classes.base + "-" + options.direction + '"><div class="' + options.classes.base + '-scrollable"><div><div class="' + options.classes.content + '"></div></div></div><div class="' + options.classes.base + '-handler"></div></div>'
            }, afterLoad: function () {
                this.$panel.find('.preloader').hide();
                this.$panel.find("." + this.options.classes.base + "-scrollable").asScrollable({
                    namespace: "scrollable",
                    contentSelector: ">",
                    containerSelector: ">"
                })
            }, beforeLoad: function () {
                this.$panel.find('.preloader').show();
            }
        });
        $(document).on("click", "[data-toggle=slidePanel]", function (e) {
            $.slidePanel.show({url: $(this).data("url"), settings: {cache: !1}}, options), e.stopPropagation()
        })
    }
}
handleSlidePanel();